
package edu.unl.consystlab.sudoku;


public class Puzzle
{
	private String name;
	private String description;
	private String[] rows;
	public Puzzle(String name, String description, String[] rows)
	{
		setName(name);
		setRows(rows);
		setDescription(description);
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public String getName()
	{
		return name;
	}

	public void setDescription(String description)
	{
		this.description = description;
	}

	public String getDescription()
	{
		return description;
	}

	public void setRows(String[] rows)
	{
		this.rows = rows;
	}

	public String[] getRows()
	{
		return rows;
	}
	
	public void fillGrid(Griddable grid)
	{
		grid.clear();
		for (int row = 0; row < Grid.SZ; row++)
		{
			String s = rows[row];
			for (int col = 0; col < Grid.SZ; col++)
			{
				char c = s.charAt(col);
				if (c >= '1' && c <= '9')
				{
					grid.lock(row,col,(byte)(c-'0'));
				}
				else
				{				
					grid.clear(row,col);
				}
			}
		}
	} // Grid(Puzzle);
}
